
%% Loading Absorbance, SMPS, and PSAP Volume Info
AAE_QualityControl();

[time_psap, samplevol, spotsize] = PSAPmatthewedit();

[time_aps, dbins, sizedist] = hiscale_APSimport();

%% Unit Conversions
dbins_um = dbins .* (1e6 ./ 1e9);
vbins_nm = 4.*pi().*(dbins./2).^3 ./ 3;
vbins_l = vbins_nm.*(10./1e9).^3;


tic
%% Main Loop
for i = 1:length(time_aps)
	%% Accounting for different sample rates
	if 5.*i <= length(rawbluefilt)
		abs_coeff_blue(i,1) = nanmean(rawbluefilt( (5.*i-4)  : 5.*i ));
	else
		abs_coeff_blue(i,1) = nanmean(rawbluefilt( (5.*i-4) : end));
	end
	
	if 5.*i <= length(rawredfilt)
		abs_coeff_red(i,1) = nanmean(rawredfilt( (5.*i-4)  : 5.*i ));
	else
		abs_coeff_red(i,1) = nanmean(rawredfilt( (5.*i-4) : end));
	end
	
	if 5.*i <= length(rawgreenfilt)
		abs_coeff_green(i,1) = nanmean(rawgreenfilt( (5.*i-4)  : 5.*i ));
	else
		abs_coeff_green(i,1) = nanmean(rawgreenfilt( (5.*i-4) : end));
	end
	
	if 5.*i <= length(samplevol)
		samplevol_avg(i,1) = nanmean(samplevol( (5.*i-4)  : 5.*i ));
	else
		samplevol_avg(i,1) = nanmean(samplevol( (5.*i-4) : end));
	end
	
	vbins_l_tot = vbins_l .* sizedist(:,i);
	volfrac_sizebin = vbins_l_tot ./ samplevol_avg(i,1); 
	
	
	%% Mie for 3 colors
	real_ri = 1.3; %linspace(0.3,4,50);
	imaginary_ri = linspace(0,3,100);
	
	if any(exist('sillystring','file'))
		hwait = waitbar(0,sillystring);
	else
		hwait = waitbar(0,'plz w8');
	end
		
	
	%for r = 1:length(real_ri)
		
	
	for k = 1:length(imaginary_ri)
		
		for d = 1:length(dbins)
			npar = real_ri + 1i.*imaginary_ri(k);
			[~, blue_temp_mus(d,1), blue_temp_mua(d,1)] = getMieScatter(0.470, dbins_um(d), volfrac_sizebin(d), npar, 1.00027717);
			[~, green_temp_mus(d,1), green_temp_mua(d,1)] = getMieScatter(0.522, dbins_um(d), volfrac_sizebin(d), npar, 1.00027717);
			[~, red_temp_mus(d,1), red_temp_mua(d,1)] = getMieScatter(0.660, dbins_um(d), volfrac_sizebin(d), npar, 1.00027717);
		end
		
		blue_mua(k,1) = nansum(blue_temp_mua,1)*1e5;
		green_mua(k,1) = nansum(green_temp_mua,1)*1e5;
		red_mua(k,1) = nansum(red_temp_mua,1)*1e5;
		
		blue_mus(k,1) = nansum(blue_temp_mus,1)*1e5;
		green_mus(k,1) = nansum(green_temp_mus,1)*1e5;
		red_mus(k,1) = nansum(red_temp_mus,1)*1e5;
	
		waitbar(k/length(imaginary_ri),hwait);
	end
	
	
	%end
	close(hwait);
	
	%% blue
	[~,imidx_b] = min(abs(blue_mua - abs_coeff_blue(i)));
	im_b(i,1) = imaginary_ri(imidx_b);
% 	[~,min_im_idx_b] = min(min(abs(blue_mua - abs_coeff_blue(i))));
% 	
% 	min_real_idx_b = min_real_idx_vec_b(min_im_idx_b);
% 	
% 	best_real_ri_blue(i,1) = real_ri(min_real_idx_b);
	
	%% Green
	[~,imidx_g] = min(abs(green_mua - abs_coeff_green(i)));
	im_g(i,1) = imaginary_ri(imidx_g);
	
	%% red
	[~,imidx_r] = min(abs(red_mua - abs_coeff_red(i)));
	im_r(i,1) = imaginary_ri(imidx_r);
% 	[~,min_im_idx_r] = min(min(abs(red_mua - abs_coeff_red(i))));
% 	
% 	min_real_idx_r = min_real_idx_vec_r(min_im_idx_r);
% 	
% 	best_real_ri_red(i,1) = real_ri(min_real_idx_r);
	
	
	toc
	bleep = 1
	
	
end



